########
# DEFiNE
########
!define APP64    ExamDiff64
;===
!define DOC      `${DATA}\My Documents`
;===
!define 32       ExamDiff\ExamDiff.exe
!define 64       ExamDiff64\ExamDiff.exe
;===
!define EXE32    `$EXEDIR\App\${32}`
!define EXE64    `$EXEDIR\App\${64}`
;===
!define SET32    `Kernel32::SetEnvironmentVariable(t "EXAMDIFF", t "ExamDiff")`
!define SET64    `Kernel32::SetEnvironmentVariable(t "EXAMDIFF", t "ExamDiff64")`
;===
!define INT      `Shell integration`
!define KEY      `Software\PrestoSoft\ExamDiff Pro\Shell`
!define CLSID    `SOFTWARE\Classes\CLSID\{58549232-7081-4541-882C-767DB238453C}\InprocServer32`
;===
!define DLL      `$EXEDIR\App\$0\EDPShell32.dll`
!define DLL64    `$EXEDIR\App\$0\EDPShell.dll`
;===
!define REG      `${SET}\${APP}.reg`
!define DEFREG   `${DEFSET}\${APP}.reg`
;===
!define BIN      `${SET}\password.bin`
!define DEFBIN   `${DEFSET}\password.bin`
;===
!define PLG      `${DATA}\Plug-Ins`
!define DEFPLG   `${DEFDATA}\Plug-Ins`
;===
!define PLG01    `${PLG}\7-Zip`
!define PLG02    `${PLG}\catdoc`
!define PLG03    `${PLG}\cURL`
!define PLG04    `${PLG}\IniSorter`
!define PLG05    `${PLG}\odt2txt`
!define PLG06    `${PLG}\OOXML2Txt`
!define PLG07    `${PLG}\PESnoop`
!define PLG08    `${PLG}\Tidy`
!define PLG09    `${PLG}\tidyjson`
!define PLG10    `${PLG}\wget`
!define PLG11    `${PLG}\XMLStarlet`
!define PLG12    `${PLG}\Xpdf`
;===
!define DEFPLG01 `${DEFPLG}\7-Zip`
!define DEFPLG02 `${DEFPLG}\catdoc`
!define DEFPLG03 `${DEFPLG}\cURL`
!define DEFPLG04 `${DEFPLG}\IniSorter`
!define DEFPLG05 `${DEFPLG}\odt2txt`
!define DEFPLG06 `${DEFPLG}\OOXML2Txt`
!define DEFPLG07 `${DEFPLG}\PESnoop`
!define DEFPLG08 `${DEFPLG}\Tidy`
!define DEFPLG09 `${DEFPLG}\tidyjson`
!define DEFPLG10 `${DEFPLG}\wget`
!define DEFPLG11 `${DEFPLG}\XMLStarlet`
!define DEFPLG12 `${DEFPLG}\Xpdf`
########
# CUSTOM
########
${SegmentFile}
${Segment.OnInit}
	Push $0
	${IsWOW64} $0
	StrCmp $0 0 ThirtyTwoBit
	IfFileExists `${EXE64}` 0 EightySixBit
	System::Call `${SET64}`
	${WriteSettings} 64 Architecture
		Goto END
	EightySixBit:
	System::Call `${SET32}`
	${WriteSettings} 64 Architecture
		Goto END
	ThirtyTwoBit:
	System::Call `${SET32}`
	${WriteSettings} 32 Architecture
	END:
	Pop $0
!macroend
;===
!macro ProExecInit
	Push $0
	ReadEnvStr $0 ${APP}
	StrCmp $0 ${APP} 0 +3
	StrCpy $ProgramExecutable ${32}
	Goto +2
	StrCpy $ProgramExecutable ${64}
	Pop $0
!macroend
;===
!macro InstanceManagement
	StrCmp $0 0 +2
	Quit
!macroend
;===
!define MsgBox "!insertmacro _MsgBox"
!macro _MsgBox
	MessageBox MB_ICONSTOP|MB_TOPMOST `${PORTABLEAPPNAME} requires Windows XP or newer`
	Call Unload
	Quit
!macroend
!macro OS
	${If} ${IsNT}
		${IfNot} ${AtLeastWinXP}
			${MsgBox}
		${EndIf}
	${Else}
		${MsgBox}
	${EndIf}
!macroend
;===
!macro Init
	IfFileExists `${DOC}` +2
	CreateDirectory `${DOC}`
	IfFileExists `${REG}` +2
	CopyFiles /SILENT `${DEFREG}` `${REG}`
	IfFileExists `${BIN}` +2
	CopyFiles /SILENT `${DEFBIN}` `${BIN}`
	IfFileExists `${PLG01}` +2
	CreateDirectory `${PLG01}`
	IfFileExists `${PLG01}\7z.dll` +2
	CopyFiles /SILENT `${DEFPLG01}\7z.dll` `${PLG01}`
	IfFileExists `${PLG01}\7z.exe` +2
	CopyFiles /SILENT `${DEFPLG01}\7z.exe` `${PLG01}`
	IfFileExists `${PLG01}\7-zip.dll` +2
	CopyFiles /SILENT `${DEFPLG01}\7-zip.dll` `${PLG01}`
	IfFileExists `${PLG02}` +2
	CreateDirectory `${PLG02}`
	IfFileExists `${PLG02}\catdoc.exe` +2
	CopyFiles /SILENT `${DEFPLG02}\catdoc.exe` `${PLG02}`
	IfFileExists `${PLG02}\catppt.exe` +2
	CopyFiles /SILENT `${DEFPLG02}\catppt.exe` `${PLG02}`
	IfFileExists `${PLG02}\xls2csv.exe` +2
	CopyFiles /SILENT `${DEFPLG02}\xls2csv.exe` `${PLG02}`
	IfFileExists `${PLG03}\curl.exe` +3
	CreateDirectory `${PLG03}`
	CopyFiles /SILENT `${DEFPLG03}\curl.exe` `${PLG03}`
	IfFileExists `${PLG04}\IniSorter.exe` +3
	CreateDirectory `${PLG04}`
	CopyFiles /SILENT `${DEFPLG04}\IniSorter.exe` `${PLG04}`
	IfFileExists `${PLG05}\odt2txt.exe` +3
	CreateDirectory `${PLG05}`
	CopyFiles /SILENT `${DEFPLG05}\odt2txt.exe` `${PLG05}`
	IfFileExists `${PLG06}` +2
	CreateDirectory `${PLG06}`
	IfFileExists `${PLG06}\Ionic.Zip.dll` +2
	CopyFiles /SILENT `${DEFPLG06}\Ionic.Zip.dll` `${PLG06}`
	IfFileExists `${PLG06}\OOXML2Txt.exe` +2
	CopyFiles /SILENT `${DEFPLG06}\OOXML2Txt.exe` `${PLG06}`
	IfFileExists `${PLG07}\PESnoop.exe` +3
	CreateDirectory `${PLG07}`
	CopyFiles /SILENT `${DEFPLG07}\PESnoop.exe` `${PLG07}`
	IfFileExists `${PLG08}` +2
	CreateDirectory `${PLG08}`
	IfFileExists `${PLG08}\tidy.dll` +2
	CopyFiles /SILENT `${DEFPLG08}\tidy.dll` `${PLG08}`
	IfFileExists `${PLG08}\tidy.exe` +2
	CopyFiles /SILENT `${DEFPLG08}\tidy.exe` `${PLG08}`
	IfFileExists `${PLG09}` +2
	CreateDirectory `${PLG09}`
	IfFileExists `${PLG09}\Jayrock.Json.dll` +2
	CopyFiles /SILENT `${DEFPLG09}\Jayrock.Json.dll` `${PLG09}`
	IfFileExists `${PLG09}\tidyjson.exe` +2
	CopyFiles /SILENT `${DEFPLG09}\tidyjson.exe` `${PLG09}`
	IfFileExists `${PLG09}\tidyjson.exe.config` +2
	CopyFiles /SILENT `${DEFPLG09}\tidyjson.exe.config` `${PLG09}`
	IfFileExists `${PLG10}` +2
	CreateDirectory `${PLG10}`
	IfFileExists `${PLG10}\wget.exe` +2
	CopyFiles /SILENT `${DEFPLG10}\wget.exe` `${PLG10}`
	IfFileExists `${PLG10}\wget.js` +2
	CopyFiles /SILENT `${DEFPLG10}\wget.js` `${PLG10}`
	IfFileExists `${PLG11}\xml.exe` +3
	CreateDirectory `${PLG11}`
	CopyFiles /SILENT `${DEFPLG11}\xml.exe` `${PLG11}`
	IfFileExists `${PLG12}\pdftotext.exe` +3
	CreateDirectory `${PLG12}`
	CopyFiles /SILENT `${DEFPLG12}\pdftotext.exe` `${PLG12}`
!macroend
;===
!macro EnvironmentVariables
	${SetEnvironmentVariable} SYSDIR $SYSDIR
	${If} ${RunningX64}
		${SetEnvironmentVariable} CLSID Wow6432Node\CLSID
	${Else}
		${SetEnvironmentVariable} CLSID CLSID
	${EndIf}
!macroend
;===
${SegmentInit}
	Push $0
	${ReadSettings} $0 LastArchitecture
	${SetEnvironmentVariable} LastArchitecture $0
	Pop $0
!macroend
;===
${SegmentPreExecPrimary}
	Push $0
	Push $1
	ReadEnvStr $0 ExamDiff
	${WriteSettings} $0 LastArchitecture
	ReadEnvStr $1 LastArchitecture
	${If} $0 != $1
		${If} $RunAsAdmin == force
			${Close} `${CABW}` ""
		${EndIf}
	${EndIf}
	Pop $1
	Pop $0
!macroend
;===
!macro CustomOverride
	${If} $SecondaryLaunch != true
	${AndIf} ${ProcessExists} ExamDiff.exe
		Quit
	${EndIf}
!macroend
!macro RunAsAdmin
	Push $0
	${ConfigReads} `${CONFIG}` ShellExtension= $0
	${If} $0 == true
		StrCpy $RunAsAdmin force
	${ElseIf} $0 == auto
		${If} ${IsAdmin}
			StrCpy $RunAsAdmin force
		${EndIf}
	${EndIf}
	Pop $0
!macroend
;===
!macro PreDLL
	${If} $RunAsAdmin == force
		Push $0
		Push $1
		ClearErrors
		ReadRegStr $0 HKLM `${CLSID}` ""
		${IfNot} ${Errors}
			StrCpy $1 $0 1
			StrCmp $1 `"` 0 +2
			StrCpy $0 $0 "" 1
			StrCpy $1 $0 "" -1
			StrCmp $1 `"` 0 +2
			StrCpy $0 $0 -1
			${WriteRuntimeData} ${PAL} DLL `$0`
			${DLL::UNREG} `$0` ""
		${EndIf}
		${If} ${RunningX64}
			SetRegView 64
			ClearErrors
			ReadRegStr $0 HKLM `${CLSID}` ""
			${IfNot} ${Errors}
				StrCpy $1 $0 1
				StrCmp $1 `"` 0 +2
				StrCpy $0 $0 "" 1
				StrCpy $1 $0 "" -1
				StrCmp $1 `"` 0 +2
				StrCpy $0 $0 -1
				${WriteRuntimeData} ${PAL} DLL64 `$0`
				${DLL::UNREG} `$0` /DISABLEFSR
			${EndIf}
			SetRegView LastUsed
		${EndIf}
		Pop $1
		Pop $0
	${EndIf}
!macroend
;===
!macro PrePrimaryDLL
	${If} $RunAsAdmin == force
		Push $0
		ReadEnvStr $0 ExamDiff
		${DLL::REG} `${DLL}` ""
		${If} ${RunningX64}
			${DLL::REG} `${DLL64}` /DISABLEFSR
		${EndIf}
		WriteRegDWORD HKCU `${KEY}` `${INT}` 0x00000001
		Pop $0
	${Else}
		WriteRegDWORD HKCU `${KEY}` `${INT}` 0x00000000
	${EndIf}
!macroend
;===
!macro PostPrimaryDLL
	${If} $RunAsAdmin == force
		Push $0
		ReadEnvStr $0 ExamDiff
		${DLL::UNREG} `${DLL}` ""
		${If} ${RunningX64}
			${DLL::UNREG} `${DLL64}` /DISABLEFSR
		${EndIf}
		Pop $0
	${EndIf}
!macroend
;===
!macro UnloadDLL
	${If} $RunAsAdmin == force
		Push $0
		ClearErrors
		${ReadRuntimeData} $0 ${PAL} DLL
		${IfNot} ${Errors}
			${DLL::REG} `$0` ""
		${EndIf}
		${If} ${RunningX64}
			ClearErrors
			${ReadRuntimeData} $0 ${PAL} DLL64
			${IfNot} ${Errors}
				${DLL::REG} `$0` /DISABLEFSR
			${EndIf}
		${EndIf}
		${ConfigReads} `${CONFIG}` USBDevice= $0
		${If} $0 == true
			${Close} `${CABW}` ""
		${EndIf}
		Pop $0
	${EndIf}
!macroend